## API Review Notes for April 15th, 2020

### Changes reviewed
Starting commit: `c827247a767c0c434dcb77496038b163b9e011da`

Ending Commit: `3375a7b209d1f590940af043e9e39f2cbb503845`

### Notes

#### Everything but Source Generators:

* `Project.RemoveDocuments`: Everything else in this type uses `IEnumerable<T>`, not `ImmutableArray<T>`. If we could start again from day 1 we might make everything that, but given that everything today uses the former, we should do so here. This applies to the overloads on `Solution` as well.
* `Solution.RemoveAdditonalDocuments/RemoveAnalyzerConfigDocuments`: We added these to `Solution`, but not to project, even though that also has the invididual `Remove` methods. We should add them to `Project` as well.
* `DocumentOptionSet.GetOption`: This API was added as a `new` on the concrete `DocumentOptionSet` to cover a change when we moved the implementation up to `OptionSet` and made the method non-virtual. This is not actually a breaking change, so we should remove this.

#### Source Generators:

As a general note, changes that we make here are _not_ considered breaking changes post 16.6.
However, we did take a broad overview of the API surface and have some notes for @chsienki.

* `GeneratorAttribute`: we should consider adding a `LanguageName` attribute to this type.
* `InitializationContext`: Rename to something like `SourceGeneratorInitialzationContext` or similar. Current name is ambiguous.
* `InitializationContext.RegisterForNotifications`:
    * Naming is inconsistent with existing `Action` ending for analyzer register methods.
    * `SyntaxReceiverCreator`: all other `RegisterForXAction` methods in analyzers use an `Action` or `Func`, as appropriate. We should consider doing the same here.
* `ISyntaxReceiver`: This may be redundant with existing APIs.
* `SourceGeneratorContext`: There is not currently a way to share semantic models and other binding info between source generators. We should design a way for this info to be shared so we can avoid introducing lots of binding from generators.
